/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app;

import colorfix.app.types.SimpleNormalizedProperty;
import javafx.beans.Observable;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.paint.Color;

public class ExtendedColor {
    private final SimpleObjectProperty<Color> color = new SimpleObjectProperty();
    private final SimpleNormalizedProperty alpha = new SimpleNormalizedProperty(0.0);
    private final SimpleNormalizedProperty red = new SimpleNormalizedProperty(0.0);
    private final SimpleNormalizedProperty green = new SimpleNormalizedProperty(0.0);
    private final SimpleNormalizedProperty blue = new SimpleNormalizedProperty(0.0);
    private final SimpleDoubleProperty hue = new SimpleDoubleProperty(0.0);
    private final SimpleNormalizedProperty saturation = new SimpleNormalizedProperty(0.0);
    private final SimpleNormalizedProperty brightness = new SimpleNormalizedProperty(0.0);
    private final SimpleNormalizedProperty cyan = new SimpleNormalizedProperty(0.0);
    private final SimpleNormalizedProperty magenta = new SimpleNormalizedProperty(0.0);
    private final SimpleNormalizedProperty yellow = new SimpleNormalizedProperty(0.0);
    private final SimpleNormalizedProperty black = new SimpleNormalizedProperty(0.0);
    private boolean localChange = false;

    public ExtendedColor(Color color) {
        this.colorProperty().addListener(this::onColorChanged);
        this.alphaProperty().addListener(this::onChangedRGBA);
        this.redProperty().addListener(this::onChangedRGBA);
        this.greenProperty().addListener(this::onChangedRGBA);
        this.blueProperty().addListener(this::onChangedRGBA);
        this.hueProperty().addListener(this::onChangedHSBA);
        this.saturationProperty().addListener(this::onChangedHSBA);
        this.brightnessProperty().addListener(this::onChangedHSBA);
        this.cyanProperty().addListener(this::onChangedCMYKA);
        this.magentaProperty().addListener(this::onChangedCMYKA);
        this.yellowProperty().addListener(this::onChangedCMYKA);
        this.blackProperty().addListener(this::onChangedCMYKA);
        this.color.set((Object)color);
    }

    public ExtendedColor(String color) {
        this(Color.web((String)color));
    }

    public SimpleObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public SimpleNormalizedProperty alphaProperty() {
        return this.alpha;
    }

    public SimpleNormalizedProperty redProperty() {
        return this.red;
    }

    public SimpleNormalizedProperty greenProperty() {
        return this.green;
    }

    public SimpleNormalizedProperty blueProperty() {
        return this.blue;
    }

    public SimpleDoubleProperty hueProperty() {
        return this.hue;
    }

    public SimpleNormalizedProperty saturationProperty() {
        return this.saturation;
    }

    public SimpleNormalizedProperty brightnessProperty() {
        return this.brightness;
    }

    public SimpleNormalizedProperty cyanProperty() {
        return this.cyan;
    }

    public SimpleNormalizedProperty magentaProperty() {
        return this.magenta;
    }

    public SimpleNormalizedProperty yellowProperty() {
        return this.yellow;
    }

    public SimpleNormalizedProperty blackProperty() {
        return this.black;
    }

    public double getAlpha() {
        return this.alpha.get();
    }

    public void setAlpha(double value) {
        this.alpha.set(value);
    }

    public Color getColor() {
        return (Color)this.color.get();
    }

    public void setColor(Color value) {
        this.color.set((Object)value);
    }

    public double getRed() {
        return this.red.get();
    }

    public void setRed(double value) {
        this.red.set(value);
    }

    public double getGreen() {
        return this.green.get();
    }

    public void setGreen(double value) {
        this.green.set(value);
    }

    public double getBlue() {
        return this.blue.get();
    }

    public void setBlue(double value) {
        this.blue.set(value);
    }

    public double getHue() {
        return this.hue.get();
    }

    public void setHue(double value) {
        this.hue.set(value);
    }

    public double getSaturation() {
        return this.saturation.get();
    }

    public void setSaturation(double value) {
        this.saturation.set(value);
    }

    public double getBrightness() {
        return this.brightness.get();
    }

    public void setBrightness(double value) {
        this.brightness.set(value);
    }

    public double getCyan() {
        return this.cyan.get();
    }

    public void setCyan(double value) {
        this.cyan.set(value);
    }

    public double getMagenta() {
        return this.magenta.get();
    }

    public void setMagenta(double value) {
        this.magenta.set(value);
    }

    public double getYellow() {
        return this.yellow.get();
    }

    public void setYellow(double value) {
        this.yellow.set(value);
    }

    public double getBlack() {
        return this.black.get();
    }

    public void setBlack(double value) {
        this.black.set(value);
    }

    protected void onColorChanged(Observable observable) {
        if (!this.localChange) {
            this.localChange = true;
            double r = this.getColor().getRed();
            double g = this.getColor().getGreen();
            double b = this.getColor().getBlue();
            this.setRed(r);
            this.setGreen(g);
            this.setBlue(b);
            this.setSaturation(this.getColor().getSaturation());
            this.setBrightness(this.getColor().getBrightness());
            this.setHue(this.getColor().getHue());
            double k = 1.0 - Math.max(Math.max(this.getRed(), this.getGreen()), this.getBlue());
            double c = this.zeroIfNaN((1.0 - r - k) / (1.0 - k));
            double m = this.zeroIfNaN((1.0 - g - k) / (1.0 - k));
            double y = this.zeroIfNaN((1.0 - b - k) / (1.0 - k));
            this.setBlack(k);
            this.setCyan(c);
            this.setMagenta(m);
            this.setYellow(y);
            this.localChange = false;
        }
    }

    private double zeroIfNaN(double value) {
        return Double.isNaN(value) ? 0.0 : value;
    }

    public void refresh() {
        this.onColorChanged((Observable)this.colorProperty());
    }

    protected void onChangedRGBA(Observable observable) {
        if (!this.localChange) {
            double r = this.getRed();
            double g = this.getGreen();
            double b = this.getBlue();
            double a = this.getAlpha();
            this.setColor(new Color(r, g, b, a));
        }
    }

    protected void onChangedHSBA(Observable observable) {
        if (!this.localChange) {
            double h = this.getHue();
            double s = this.getSaturation();
            double b = this.getBrightness();
            double a = this.getAlpha();
            this.setColor(Color.hsb((double)h, (double)s, (double)b, (double)a));
        }
    }

    protected void onChangedCMYKA(Observable observable) {
        if (!this.localChange) {
            double k = this.zeroIfNaN(this.getBlack());
            double c = this.zeroIfNaN(this.getCyan());
            double m = this.zeroIfNaN(this.getMagenta());
            double y = this.zeroIfNaN(this.getYellow());
            double r = (1.0 - c) * (1.0 - k);
            double g = (1.0 - m) * (1.0 - k);
            double b = (1.0 - y) * (1.0 - k);
            double a = this.getAlpha();
            this.setColor(new Color(r, g, b, a));
        }
    }
}

