/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls;

import colorfix.app.ExtendedColor;
import colorfix.app.util.ColorUtil;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ColorThumbnail
extends Pane {
    protected final Canvas canvas;
    protected final GraphicsContext graphics;
    private ExtendedColor color;

    public ColorThumbnail() {
        this(Color.RED);
    }

    public ColorThumbnail(Color color) {
        this(new ExtendedColor(color));
    }

    public ColorThumbnail(ExtendedColor color) {
        this.color = color;
        this.canvas = new Canvas();
        this.graphics = this.canvas.getGraphicsContext2D();
        this.canvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.widthProperty().addListener(e -> this.draw());
        this.heightProperty().addListener(e -> this.draw());
        this.colorProperty().addListener(e -> this.draw());
        this.getChildren().add((Object)this.canvas);
    }

    public void draw() {
        double halfWidth = this.getWidth() / 2.0;
        Color c = (Color)this.colorProperty().get();
        this.graphics.setFill((Paint)c);
        this.graphics.fillRect(0.0, 0.0, halfWidth, this.getHeight());
        this.graphics.setFill((Paint)ColorUtil.grayScaleColor(c));
        this.graphics.fillRect(halfWidth, 0.0, halfWidth, this.getHeight());
        this.graphics.setLineWidth(1.0);
        this.graphics.setStroke((Paint)Color.BLACK);
        this.graphics.strokeRect(0.0, 0.0, this.getWidth(), this.getHeight());
        this.graphics.setStroke((Paint)Color.WHITE);
        this.graphics.strokeRect(1.0, 1.0, this.getWidth() - 2.0, this.getHeight() - 2.0);
        this.graphics.setStroke((Paint)Color.BLACK);
        this.graphics.strokeRect(2.0, 2.0, this.getWidth() - 4.0, this.getHeight() - 4.0);
    }

    public boolean isResizable() {
        return true;
    }

    public SimpleObjectProperty<Color> colorProperty() {
        return this.color.colorProperty();
    }
}

