/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls.picker;

import colorfix.app.ExtendedColor;
import colorfix.app.controls.picker.ColorSquareAbstract;
import colorfix.app.util.Assets;
import colorfix.app.util.ColorUtil;
import colorfix.app.util.Maths;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public class ColorSquare
extends ColorSquareAbstract {
    private Pane saturationOverlay;
    private Pane brightnessOverlay;
    private Region colorSquareIndicator;
    private Pane colorBar;
    private Region colorBarIndicator;
    private Region border;
    final double COLOR_BAR_SIZE = 32.0;
    final double CURSOR_SIZE = 10.0;
    final double HALF_CURSOR_SIZE = 5.0;
    final Insets INSETS = new Insets(5.0);
    final double SCROLL_FACTOR = 18.0;

    public ColorSquare() {
        this(Color.RED);
    }

    public ColorSquare(Color color) {
        this(new ExtendedColor(color));
    }

    public ColorSquare(ExtendedColor color) {
        super(color);
        this.getStylesheets().add((Object)Assets.getAssetPath("/color-picker.css"));
        this.getStyleClass().add((Object)"color-picker");
        this.setSpacing(5.0);
        this.setPadding(new Insets(10.0));
        this.saturationOverlay = new Pane();
        this.brightnessOverlay = new Pane();
        this.brightnessOverlay.setBackground(this.getBrightnessBackground());
        this.brightnessOverlay.setPadding(this.INSETS);
        this.saturationOverlay.getChildren().add((Object)this.brightnessOverlay);
        this.colorSquareIndicator = new Region();
        this.colorSquareIndicator.setCache(true);
        this.colorSquareIndicator.getStyleClass().add((Object)"color-indicator");
        this.colorSquareIndicator.setPrefSize(10.0, 10.0);
        this.border = new Region();
        this.border.setCache(true);
        this.border.getStyleClass().add((Object)"color-pane-border");
        this.brightnessOverlay.getChildren().setAll((Object[])new Node[]{this.border, this.colorSquareIndicator});
        this.colorBar = new Pane();
        this.colorBar.setBackground(this.getHueBackground());
        this.colorBar.setPrefWidth(42.0);
        this.colorBarIndicator = new Region();
        this.colorBarIndicator.setCache(true);
        this.colorBarIndicator.getStyleClass().add((Object)"color-indicator");
        this.colorBarIndicator.setPrefHeight(10.0);
        this.colorBar.getChildren().setAll((Object[])new Node[]{this.colorBarIndicator});
        HBox.setHgrow((Node)this.saturationOverlay, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.saturationOverlay, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.colorBar, (Priority)Priority.ALWAYS);
        this.redraw();
        this.getChildren().addAll((Object[])new Node[]{this.saturationOverlay, this.colorBar});
        this.colorBar.setOnMousePressed(this::onBarSelected);
        this.colorBar.setOnMouseDragged(this::onBarSelected);
        this.colorBar.setOnScroll(this::onBarScroll);
        this.brightnessOverlay.setOnMousePressed(this::onSquareSelected);
        this.brightnessOverlay.setOnMouseDragged(this::onSquareSelected);
        this.setBindings();
    }

    private void setBindings() {
        this.brightnessOverlay.prefWidthProperty().bind((ObservableValue)this.saturationOverlay.widthProperty());
        this.brightnessOverlay.prefHeightProperty().bind((ObservableValue)this.saturationOverlay.heightProperty());
        this.border.prefWidthProperty().bind((ObservableValue)this.brightnessOverlay.widthProperty().subtract(10.0).add(2.0));
        this.border.prefHeightProperty().bind((ObservableValue)this.brightnessOverlay.heightProperty().subtract(10.0).add(2.0));
        this.border.setLayoutX(4.0);
        this.border.setLayoutY(4.0);
        DoubleBinding hueProp = this.hueProperty().divide(360.0);
        SimpleDoubleProperty satProp = this.saturationProperty();
        SimpleDoubleProperty brightProp = this.brightnessProperty();
        DoubleBinding barHProp = this.colorBar.heightProperty().subtract(10.0);
        this.colorBarIndicator.layoutYProperty().bind((ObservableValue)hueProp.multiply((ObservableNumberValue)barHProp));
        this.colorBarIndicator.prefWidthProperty().bind((ObservableValue)this.colorBar.widthProperty());
        DoubleBinding squareWProp = this.brightnessOverlay.widthProperty().subtract(10.0);
        this.colorSquareIndicator.layoutXProperty().bind((ObservableValue)satProp.multiply((ObservableNumberValue)squareWProp));
        DoubleBinding squareHProp = this.brightnessOverlay.heightProperty().subtract(10.0);
        this.colorSquareIndicator.layoutYProperty().bind((ObservableValue)Bindings.subtract((int)1, (ObservableNumberValue)brightProp).multiply((ObservableNumberValue)squareHProp));
        this.colorBarIndicator.layoutYProperty().addListener(e -> this.redraw());
    }

    private Background getBrightnessBackground() {
        Stop begin = new Stop(0.0, new Color(0.0, 0.0, 0.0, 0.0));
        Stop end = new Stop(1.0, Color.BLACK);
        LinearGradient gradient = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.REPEAT, new Stop[]{begin, end});
        BackgroundFill fill = new BackgroundFill((Paint)gradient, CornerRadii.EMPTY, this.INSETS);
        return new Background(new BackgroundFill[]{fill});
    }

    private Background getSaturationBackground(double hue) {
        Color hueColor = Color.hsb((double)hue, (double)1.0, (double)1.0);
        Color hueColorTransparent = new Color(hueColor.getRed(), hueColor.getGreen(), hueColor.getBlue(), 0.0);
        Stop begin = new Stop(0.0, hueColorTransparent);
        Stop end = new Stop(1.0, hueColor);
        LinearGradient gradient = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.REPEAT, new Stop[]{begin, end});
        BackgroundFill fill = new BackgroundFill((Paint)gradient, CornerRadii.EMPTY, this.INSETS);
        return new Background(new BackgroundFill[]{fill});
    }

    private Background getHueBackground() {
        Stop[] stops = new Stop[360];
        int i = 0;
        while (i < 360) {
            stops[i] = new Stop((double)i / 360.0, Color.hsb((double)i, (double)1.0, (double)1.0));
            ++i;
        }
        LinearGradient gradient = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.REPEAT, stops);
        BackgroundFill fill = new BackgroundFill((Paint)gradient, CornerRadii.EMPTY, this.INSETS);
        return new Background(new BackgroundFill[]{fill});
    }

    @Override
    protected void redraw() {
        double hue = 0.0;
        try {
            hue = this.hueProperty().get();
        }
        catch (NullPointerException e) {
            hue = 0.0;
        }
        if (this.saturationOverlay != null) {
            this.saturationOverlay.setBackground(this.getSaturationBackground(hue));
        }
        Color color = Color.hsb((double)hue, (double)1.0, (double)1.0);
        String hex = ColorUtil.tohexCode(color);
        if (this.colorBarIndicator != null) {
            this.colorBarIndicator.setStyle("-fx-border-color: " + hex + ";");
        }
    }

    protected void onBarSelected(MouseEvent e) {
        if (e.getButton() != MouseButton.PRIMARY) {
            return;
        }
        double h = this.colorBar.getHeight();
        double lerp = Maths.clamp(e.getY(), 5.0, h - 5.0 - 1.0) - 5.0;
        this.hueProperty().set((lerp /= h - 10.0) * 360.0);
    }

    private void onBarScroll(ScrollEvent e) {
        double hue = this.hueProperty().get() + 360.0;
        hue -= 18.0 * (e.getDeltaY() / e.getMultiplierY());
        this.hueProperty().set(hue %= 360.0);
    }

    private void onSquareSelected(MouseEvent e) {
        if (e.getButton() != MouseButton.PRIMARY) {
            return;
        }
        double w = this.brightnessOverlay.getWidth();
        double h = this.brightnessOverlay.getHeight();
        double lerp = Maths.clamp(e.getX(), 5.0, w - 5.0) - 5.0;
        this.saturationProperty().set(lerp /= w - 10.0);
        lerp = Maths.clamp(e.getY(), 5.0, h - 5.0) - 5.0;
        lerp = 1.0 - lerp / (h - 10.0);
        this.brightnessProperty().set(lerp);
    }
}

