/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls.picker;

import colorfix.app.ExtendedColor;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;

public abstract class ColorSquareAbstract
extends HBox {
    private boolean localChange = false;
    private ExtendedColor color;
    private SimpleDoubleProperty hueProp = new SimpleDoubleProperty(0.0);
    private SimpleDoubleProperty satProp = new SimpleDoubleProperty(0.0);
    private SimpleDoubleProperty brightProp = new SimpleDoubleProperty(0.0);

    protected ColorSquareAbstract(ExtendedColor color) {
        this.color = color;
        this.colorProperty().addListener(this::onColorChanged);
        this.hueProperty().addListener(this::onHueChanged);
        this.saturationProperty().addListener(this::onSaturationChanged);
        this.brightnessProperty().addListener(this::onBrightnessChanged);
        this.colorProperty().set((Object)Color.RED);
    }

    private void onColorChanged(ObservableValue<? extends Color> observable, Color before, Color after) {
        if (!this.localChange) {
            this.localChange = true;
            this.hueProperty().set(after.getHue());
            this.saturationProperty().set(after.getSaturation());
            this.brightnessProperty().set(after.getBrightness());
            this.localChange = false;
        }
        this.redraw();
    }

    private void onHueChanged(ObservableValue<? extends Number> observable, Number before, Number after) {
        if (!this.localChange) {
            this.localChange = true;
            this.colorProperty().set((Object)Color.hsb((double)after.doubleValue(), (double)this.saturationProperty().get(), (double)this.brightnessProperty().get()));
            this.localChange = false;
        }
        this.redraw();
    }

    private void onSaturationChanged(ObservableValue<? extends Number> observable, Number before, Number after) {
        if (!this.localChange) {
            this.localChange = true;
            this.colorProperty().set((Object)Color.hsb((double)this.hueProperty().get(), (double)after.doubleValue(), (double)this.brightnessProperty().get()));
            this.localChange = false;
        }
        this.redraw();
    }

    private void onBrightnessChanged(ObservableValue<? extends Number> observable, Number before, Number after) {
        if (!this.localChange) {
            this.localChange = true;
            this.colorProperty().set((Object)Color.hsb((double)this.hueProperty().get(), (double)this.saturationProperty().get(), (double)after.doubleValue()));
            this.localChange = false;
        }
        this.redraw();
    }

    public SimpleObjectProperty<Color> colorProperty() {
        return this.color.colorProperty();
    }

    public SimpleDoubleProperty hueProperty() {
        return this.color.hueProperty();
    }

    public SimpleDoubleProperty saturationProperty() {
        return this.color.saturationProperty();
    }

    public SimpleDoubleProperty brightnessProperty() {
        return this.color.brightnessProperty();
    }

    protected abstract void redraw();
}

