/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls.slider;

import colorfix.app.enums.ColorComponent;
import colorfix.app.types.SimpleNormalizedProperty;
import colorfix.app.util.Assets;
import colorfix.app.util.Maths;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class ColorSlider
extends HBox {
    private SimpleObjectProperty<ColorComponent> component = new SimpleObjectProperty();
    private SimpleNormalizedProperty value;
    private final Label name;
    private final Slider slider;
    private final Spinner<Integer> spinner;
    private SpinnerValueFactory.IntegerSpinnerValueFactory valueFactory;
    private boolean localChange = false;

    public ColorSlider(ColorComponent component) {
        this.value = new SimpleNormalizedProperty(0.0, component.equals((Object)ColorComponent.HUE) ? 360 : 1);
        this.getStylesheets().add((Object)Assets.getAssetPath("/color-sliders.css"));
        this.getStylesheets().add((Object)Assets.getAssetPath("/color-components.css"));
        this.name = new Label();
        this.name.setPrefWidth(60.0);
        this.name.minWidthProperty().bind((ObservableValue)this.name.prefWidthProperty());
        this.name.setAlignment(Pos.CENTER_RIGHT);
        this.slider = new Slider();
        this.slider.setSnapToTicks(false);
        this.slider.setShowTickMarks(false);
        this.slider.setShowTickLabels(false);
        this.slider.getStyleClass().add((Object)"color-slider");
        HBox.setHgrow((Node)this.slider, (Priority)Priority.ALWAYS);
        this.spinner = new Spinner();
        this.spinner.setPrefWidth(70.0);
        this.spinner.minWidthProperty().bind((ObservableValue)this.spinner.prefWidthProperty());
        this.component.addListener(this::onComponentChanged);
        this.component.set((Object)component);
        this.setPadding(new Insets(4.0));
        this.setSpacing(12.0);
        this.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Object[])new Node[]{this.name, this.slider, this.spinner});
        this.slider.valueProperty().addListener(this::onSliderChanged);
        this.spinner.valueProperty().addListener(this::onSpinnerChanged);
        this.value.addListener(this::onValueChanged);
    }

    private void onValueChanged(Observable observable) {
        if (!this.localChange) {
            this.slider.setValue(this.value.getNormalized() * 100.0);
        }
    }

    private void onSliderChanged(Observable observable) {
        String s = String.format("%s = %s", ((ColorComponent)((Object)this.component.get())).name(), Double.toString(this.slider.getValue()));
        if (!this.localChange) {
            this.localChange = true;
            int maximum = ((ColorComponent)((Object)this.component.get())).getMaximum();
            int newValue = (int)(this.slider.getValue() / 100.0 * (double)maximum);
            this.valueFactory.setValue((Object)newValue);
            this.value.setNormalized(Maths.clamp01(this.slider.getValue() / 100.0));
            this.localChange = false;
        }
    }

    private void onSpinnerChanged(Observable observable) {
        if (!this.localChange) {
            this.localChange = true;
            double maximum = ((ColorComponent)((Object)this.component.get())).getMaximum();
            double newValue = (double)((Integer)this.spinner.getValue()).intValue() / maximum;
            this.slider.setValue(newValue * 100.0);
            this.value.setNormalized(newValue);
            this.localChange = false;
        }
    }

    private void onComponentChanged(ObservableValue<? extends ColorComponent> observable, ColorComponent oldValue, ColorComponent newValue) {
        this.name.setText(((ColorComponent)((Object)this.component.get())).toString());
        if (newValue != null) {
            this.slider.setId(newValue.cssClass());
            this.valueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(0, newValue.getMaximum(), 0, 1);
            this.spinner.setValueFactory((SpinnerValueFactory)this.valueFactory);
        }
    }

    public SimpleObjectProperty<ColorComponent> componentProperty() {
        return this.component;
    }

    public ColorComponent getComponent() {
        return (ColorComponent)((Object)this.component.get());
    }

    public void setComponent(ColorComponent value) {
        this.component.set((Object)value);
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public double getValue() {
        return this.value.get();
    }

    public void setValue(double value) {
        this.value.set(value);
    }
}

