/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls.slider;

import colorfix.app.ExtendedColor;
import colorfix.app.controls.slider.ColorSlider;
import colorfix.app.enums.ColorComponent;
import colorfix.app.enums.ColorSpace;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

public class ColorSpaceSliderTab
extends Tab {
    private final ColorSpace COLOR_SPACE;
    private final ExtendedColor COLOR;

    public ColorSpaceSliderTab(ColorSpace cSpace) {
        this(Color.RED, cSpace);
    }

    public ColorSpaceSliderTab(Color color, ColorSpace cSpace) {
        this(new ExtendedColor(color), cSpace);
    }

    public ColorSpaceSliderTab(ExtendedColor color, ColorSpace cSpace) {
        this.COLOR_SPACE = cSpace;
        this.COLOR = color;
        this.setText(cSpace.name());
        this.setContent(this.initializeTab());
        this.setClosable(false);
    }

    private Node initializeTab() {
        VBox page = new VBox();
        page.setPadding(new Insets(12.0));
        page.setSpacing(12.0);
        page.setAlignment(Pos.TOP_CENTER);
        for (ColorComponent cComponent : this.COLOR_SPACE) {
            ColorSlider slider = new ColorSlider(cComponent);
            HBox.setHgrow((Node)slider, (Priority)Priority.ALWAYS);
            this.setBindings(slider);
            page.getChildren().add((Object)slider);
        }
        ScrollPane scroll = new ScrollPane((Node)page);
        scroll.getStyleClass().add((Object)"tab-content");
        page.prefWidthProperty().bind((ObservableValue)scroll.widthProperty());
        scroll.prefHeightProperty().bind((ObservableValue)page.prefHeightProperty());
        return scroll;
    }

    private void setBindings(ColorSlider slider) {
        ColorComponent c = slider.getComponent();
        DoubleProperty slideProp = slider.valueProperty();
        SimpleDoubleProperty colorProp = c.value01Property(this.COLOR);
        slideProp.bindBidirectional((Property)colorProp);
    }

    public SimpleObjectProperty<Color> colorProperty() {
        return this.COLOR.colorProperty();
    }
}

