/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls.table;

import colorfix.app.controls.table.columns.ColorSpaceColumn;
import colorfix.app.controls.table.columns.ColorThumbnailColumn;
import colorfix.app.controls.table.columns.EditActionsColumn;
import colorfix.app.controls.table.columns.HexadecimalValueColumn;
import colorfix.app.enums.ColorSpace;
import colorfix.app.stages.dialogs.ColorChooserDialog;
import colorfix.app.util.ColorUtil;
import java.util.Map;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

public class ColorTableView
extends TableView<Color> {
    private SimpleBooleanProperty hexVisible = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty rgbVisible = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty cmykVisible = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty hsbVisible = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty isEmpty = new SimpleBooleanProperty();
    private ContextMenu contextMenu;
    private final Clipboard clipboard = Clipboard.getSystemClipboard();
    private final ClipboardContent content = new ClipboardContent();
    private final ColorSpaceColumn columnRGB;
    private final ColorSpaceColumn columnHSB;
    private final ColorSpaceColumn columnCMYK;

    public ColorTableView() {
        ColorThumbnailColumn columnThumbnail = new ColorThumbnailColumn();
        HexadecimalValueColumn columnHex = new HexadecimalValueColumn();
        this.columnRGB = new ColorSpaceColumn(ColorSpace.RGB);
        this.columnHSB = new ColorSpaceColumn(ColorSpace.HSB);
        this.columnCMYK = new ColorSpaceColumn(ColorSpace.CMYK);
        this.setOnMouseClicked(this::onMouseClicked);
        columnHex.visibleProperty().bind((ObservableValue)this.hexVisible);
        this.columnRGB.visibleProperty().bind((ObservableValue)this.rgbVisible);
        this.columnCMYK.visibleProperty().bind((ObservableValue)this.cmykVisible);
        this.columnHSB.visibleProperty().bind((ObservableValue)this.hsbVisible);
        EditActionsColumn columnAction = new EditActionsColumn();
        this.getColumns().addAll((Object[])new TableColumn[]{columnThumbnail, columnHex, this.columnRGB, this.columnCMYK, this.columnHSB, columnAction});
        this.contextMenu = new ContextMenu();
        MenuItem menuItemAdd = new MenuItem("Ajouter");
        menuItemAdd.setOnAction(this::onItemAdd);
        MenuItem menuItemMod = new MenuItem("Modifier");
        menuItemMod.setOnAction(this::onItemModify);
        MenuItem menuItemDel = new MenuItem("Supprimer");
        menuItemDel.setOnAction(this::onItemDelete);
        MenuItem menuItemCpy = new MenuItem("Copier code hexad\u00e9cimal");
        menuItemCpy.setOnAction(this::onItemCopy);
        SeparatorMenuItem separatorMenuItem = new SeparatorMenuItem();
        SeparatorMenuItem separatorMenuItem2 = new SeparatorMenuItem();
        SeparatorMenuItem separatorMenuItem3 = new SeparatorMenuItem();
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{menuItemAdd, separatorMenuItem, menuItemMod, separatorMenuItem2, menuItemDel, separatorMenuItem3, menuItemCpy});
        this.itemsProperty().addListener(e -> this.getItems().addListener(this::onTableModified));
        this.setItems(FXCollections.observableArrayList());
        this.onTableModified(null);
    }

    private void onMouseClicked(MouseEvent e) {
        if (e.getButton() == MouseButton.SECONDARY) {
            this.contextMenu.show((Node)this, e.getScreenX(), e.getScreenY());
        } else {
            this.contextMenu.hide();
        }
    }

    private void onItemAdd(ActionEvent e) {
        Color c = ColorChooserDialog.open();
        if (c != null) {
            this.getItems().add((Object)c);
        }
    }

    private void onTableModified(ListChangeListener.Change<? extends Color> c) {
        this.isEmpty.set(this.getItems().isEmpty());
    }

    private void onItemModify(ActionEvent e) {
        int index = this.getSelectionModel().getFocusedIndex();
        Color oldCol = (Color)this.getItems().get(index);
        Color newCol = ColorChooserDialog.open(oldCol);
        if (newCol != null) {
            this.getItems().set(index, (Object)newCol);
        }
    }

    private void onItemDelete(ActionEvent e) {
        int index = this.getFocusModel().getFocusedCell().getRow();
        this.getItems().remove(index);
    }

    private void onItemCopy(ActionEvent e) {
        int index = this.getFocusModel().getFocusedCell().getRow();
        this.content.putString(ColorUtil.tohexCode((Color)this.getItems().get(index)));
        this.clipboard.setContent((Map)this.content);
    }

    public ReadOnlyBooleanProperty isEmptyProperty() {
        return ReadOnlyBooleanProperty.readOnlyBooleanProperty((ReadOnlyProperty)this.isEmpty);
    }

    public ColorSpaceColumn getRGBColumn() {
        return this.columnRGB;
    }

    public ColorSpaceColumn getHSBColumn() {
        return this.columnHSB;
    }

    public ColorSpaceColumn getCMYKColumn() {
        return this.columnCMYK;
    }

    public SimpleBooleanProperty hexVisibleProperty() {
        return this.hexVisible;
    }

    public SimpleBooleanProperty rgbVisibleProperty() {
        return this.rgbVisible;
    }

    public SimpleBooleanProperty hsbVisibleProperty() {
        return this.hsbVisible;
    }

    public SimpleBooleanProperty cmykVisibleProperty() {
        return this.cmykVisible;
    }

    public boolean isHexVisible() {
        return this.hexVisible.get();
    }

    public void setHexVisible(boolean value) {
        this.hexVisible.set(value);
    }

    public boolean isRgbVisible() {
        return this.rgbVisible.get();
    }

    public void setRgbVisible(boolean value) {
        this.rgbVisible.set(value);
    }

    public boolean isHsbVisible() {
        return this.hsbVisible.get();
    }

    public void setHsbVisible(boolean value) {
        this.hsbVisible.set(value);
    }

    public boolean isCmykVisible() {
        return this.cmykVisible.get();
    }

    public void setCmykVisible(boolean value) {
        this.cmykVisible.set(value);
    }
}

