/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls.table;

import java.util.Arrays;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class TablePlaceholder
extends VBox {
    private final Label TITLE;
    private final Label DESCRIPTION;
    private Hyperlink[] actions;

    public TablePlaceholder(String title, String description) {
        this(title, description, new Node[0]);
    }

    public TablePlaceholder(String title, String description, Node ... widgets) {
        this(title, description, Arrays.asList(widgets));
    }

    public TablePlaceholder(String title, String description, Collection<Node> widgets) {
        this(title, null, description, widgets);
    }

    public TablePlaceholder(String title, Image graphics, String description, Node ... widgets) {
        this(title, graphics, description, Arrays.asList(widgets));
    }

    public TablePlaceholder(String title, Image graphics, String description, Collection<Node> widgets) {
        this.setSpacing(8.0);
        this.setPadding(new Insets(4.0));
        this.setAlignment(Pos.CENTER);
        HBox titleBox = new HBox();
        titleBox.setSpacing(8.0);
        titleBox.setPadding(Insets.EMPTY);
        titleBox.setAlignment(Pos.CENTER);
        this.TITLE = new Label(title);
        this.TITLE.setFont(new Font("Arial", 32.0));
        this.TITLE.setTextFill((Paint)Color.LIGHTGRAY);
        if (graphics != null) {
            ImageView icon = new ImageView(graphics);
            icon.setPreserveRatio(true);
            icon.setSmooth(true);
            icon.setCache(true);
            icon.setFitHeight(this.TITLE.getFont().getSize());
            titleBox.getChildren().add((Object)icon);
        }
        titleBox.getChildren().add((Object)this.TITLE);
        this.DESCRIPTION = new Label(description);
        this.DESCRIPTION.setTextFill((Paint)Color.GRAY);
        this.getChildren().addAll((Object[])new Node[]{titleBox, this.DESCRIPTION});
        if (widgets != null && widgets.size() > 0) {
            Region spacer = new Region();
            spacer.setMinHeight(0.0);
            spacer.setPrefHeight(4.0);
            spacer.maxHeightProperty().bind((ObservableValue)spacer.prefHeightProperty());
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            FlowPane container = new FlowPane(Orientation.HORIZONTAL);
            container.setPadding(Insets.EMPTY);
            container.setAlignment(Pos.CENTER);
            container.setVgap(2.0);
            container.setHgap(4.0);
            container.setMaxWidth(500.0);
            HBox.setHgrow((Node)container, (Priority)Priority.ALWAYS);
            container.getChildren().addAll(widgets);
            this.getChildren().addAll((Object[])new Node[]{spacer, container});
        }
    }
}

