/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls.table.columns;

import colorfix.app.controls.table.columns.ColorComponentColumn;
import colorfix.app.enums.ColorComponent;
import colorfix.app.enums.ColorSpace;
import colorfix.app.util.TableColumnUtil;
import javafx.scene.control.TableColumn;
import javafx.scene.paint.Color;

public class ColorSpaceColumn
extends TableColumn<Color, String> {
    private final ColorSpace COLOR_SPACE;

    public ColorSpaceColumn(ColorSpace colorSpace) {
        super(colorSpace.toString());
        this.COLOR_SPACE = colorSpace;
        TableColumnUtil.setCommonBehavior(this, true, true, true);
        this.setHeaderStyle();
        for (ColorComponent component : colorSpace) {
            this.getColumns().add((Object)new ColorComponentColumn(component));
        }
        this.widthProperty().addListener(x -> {
            for (TableColumn column : this.getColumns()) {
                column.setPrefWidth(this.getWidth() / (double)this.getColumns().size());
            }
        });
    }

    private void setHeaderStyle() {
        this.setStyle("-fx-table-cell-border-color: lightgray;");
    }
}

