/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls.table.columns;

import colorfix.app.controls.ColorThumbnail;
import colorfix.app.util.TableColumnUtil;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.TableColumn;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ColorThumbnailColumn
extends TableColumn<Color, ColorThumbnail> {
    public ColorThumbnailColumn() {
        super("Couleur");
        this.setCellValueFactory(this::getCellValue);
        TableColumnUtil.setMinWidth(this, 85.0);
        TableColumnUtil.setCommonBehavior(this, true, true, true);
        this.setHeaderStyle();
    }

    private void setHeaderStyle() {
        this.setStyle("-fx-table-cell-border-color: lightgray;");
    }

    protected ObservableValue<ColorThumbnail> getCellValue(TableColumn.CellDataFeatures<Color, ColorThumbnail> cell) {
        Color color = (Color)cell.getValue();
        double size = 20.0;
        ColorThumbnail thumb = new ColorThumbnail(color);
        thumb.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        return new SimpleObjectProperty((Object)thumb);
    }

    private void drawCanvas(Canvas canvas, Color color) {
        GraphicsContext gc = canvas.getGraphicsContext2D();
        double width = canvas.getWidth() - 5.0;
        gc.setFill((Paint)color);
        gc.fillRect(0.0, 0.0, width, canvas.getHeight());
        gc.setStroke((Paint)Color.BLACK);
        gc.strokeRect(0.0, 0.0, width, canvas.getHeight());
    }
}

