/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls.table.columns;

import colorfix.app.util.ColorUtil;
import colorfix.app.util.TableColumnUtil;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.paint.Color;
import javafx.util.Callback;

public class CopyActionsColumn
extends TableColumn<Color, Void> {
    private final Clipboard clipboard = Clipboard.getSystemClipboard();
    private final ClipboardContent content = new ClipboardContent();

    public CopyActionsColumn() {
        super("Actions");
        TableColumnUtil.setMinWidth(this, 100.0);
        TableColumnUtil.setCommonBehavior(this, true, true, false);
        this.setCellFactory(new ActionCellFactory());
    }

    private class ActionCell
    extends TableCell<Color, Void> {
        private final Button BUTTON = new Button("Copier");

        public ActionCell() {
            this.BUTTON.setOnAction(this::onButtonClicked);
            this.BUTTON.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        }

        private void onButtonClicked(ActionEvent e) {
            CopyActionsColumn.this.content.putString(ColorUtil.tohexCode((Color)this.getTableView().getItems().get(this.getIndex())));
            CopyActionsColumn.this.clipboard.setContent((Map)CopyActionsColumn.this.content);
        }

        public void updateItem(Void item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setGraphic(null);
            } else {
                this.setGraphic((Node)this.BUTTON);
            }
        }
    }

    private class ActionCellFactory
    implements Callback<TableColumn<Color, Void>, TableCell<Color, Void>> {
        private ActionCellFactory() {
        }

        public TableCell<Color, Void> call(TableColumn<Color, Void> param) {
            return new ActionCell();
        }
    }
}

