/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls.table.columns;

import colorfix.app.stages.dialogs.ColorChooserDialog;
import colorfix.app.util.Assets;
import colorfix.app.util.TableColumnUtil;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;

public class EditActionsColumn
extends TableColumn<Color, Void> {
    public EditActionsColumn() {
        super("Actions");
        TableColumnUtil.setMinWidth(this, 200.0);
        TableColumnUtil.setCommonBehavior(this, true, true, false);
        this.setCellFactory(new ActionCellFactory());
    }

    private class ActionCell
    extends TableCell<Color, Void> {
        private final Button DELETE_BUTTON;
        private final Button EDIT_BUTTON;
        private final HBox PANE = new HBox();

        public ActionCell() {
            this.PANE.setAlignment(Pos.CENTER);
            this.PANE.setSpacing(0.0);
            this.PANE.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
            this.PANE.prefWidthProperty().bind((ObservableValue)this.widthProperty());
            Insets padding = this.PANE.getPadding();
            DoubleBinding halfWidthProp = this.PANE.widthProperty().subtract(padding.getLeft() + padding.getRight()).divide(2);
            this.EDIT_BUTTON = new Button("Modifier");
            this.EDIT_BUTTON.setOnAction(this::onEditButtonClicked);
            this.EDIT_BUTTON.prefWidthProperty().bind((ObservableValue)halfWidthProp);
            this.EDIT_BUTTON.getStyleClass().addAll((Object[])new String[]{"pill-button", "left-pill"});
            this.DELETE_BUTTON = new Button("Supprimer");
            this.DELETE_BUTTON.setOnAction(this::onDeleteButtonClicked);
            this.DELETE_BUTTON.prefWidthProperty().bind((ObservableValue)halfWidthProp);
            this.DELETE_BUTTON.getStyleClass().addAll((Object[])new String[]{"pill-button", "right-pill"});
            this.DELETE_BUTTON.setStyle("-fx-base: firebrick;");
            this.PANE.getStylesheets().add((Object)Assets.getAssetPath("/pill-button.css"));
            this.PANE.getChildren().addAll((Object[])new Node[]{this.EDIT_BUTTON, this.DELETE_BUTTON});
        }

        private void onDeleteButtonClicked(ActionEvent e) {
            this.getTableView().getItems().remove(this.getIndex());
        }

        private void onEditButtonClicked(ActionEvent e) {
            Color currentCol = (Color)this.getTableView().getItems().get(this.getIndex());
            Color newCol = ColorChooserDialog.open(currentCol);
            if (newCol != null) {
                this.getTableView().getItems().set(this.getIndex(), (Object)newCol);
            }
        }

        public void updateItem(Void item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setGraphic(null);
            } else {
                this.setGraphic((Node)this.PANE);
            }
        }
    }

    private class ActionCellFactory
    implements Callback<TableColumn<Color, Void>, TableCell<Color, Void>> {
        private ActionCellFactory() {
        }

        public TableCell<Color, Void> call(TableColumn<Color, Void> param) {
            return new ActionCell();
        }
    }
}

