/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.controls.table.columns;

import colorfix.app.util.ColorUtil;
import colorfix.app.util.TableColumnUtil;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.paint.Color;

public class HexadecimalValueColumn
extends TableColumn<Color, String> {
    public HexadecimalValueColumn() {
        super("Hexad\u00e9cimal");
        this.setCellValueFactory(this::getCellValue);
        TableColumnUtil.setMinWidth(this, 100.0);
        TableColumnUtil.setCommonBehavior(this, true, true, true);
        this.setHeaderStyle();
    }

    private void setHeaderStyle() {
        StringBuilder css = new StringBuilder();
        css.append("-fx-table-cell-border-color: lightgray;");
        this.setStyle(css.toString());
    }

    protected ObservableValue<String> getCellValue(TableColumn.CellDataFeatures<Color, String> cell) {
        Color color = (Color)cell.getValue();
        return new SimpleStringProperty(ColorUtil.tohexCode(color));
    }
}

