/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.enums;

import colorfix.app.ExtendedColor;
import java.util.function.Function;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.scene.paint.Color;

public enum ColorComponent {
    RED("Rouge", Color.web((String)"de6060"), ExtendedColor::redProperty, 255),
    GREEN("Vert", Color.web((String)"a3cf4a"), ExtendedColor::greenProperty, 255),
    BLUE("Bleu", Color.web((String)"60a7de"), ExtendedColor::blueProperty, 255),
    HUE("Teinte", Color.web((String)"ffffff"), ExtendedColor::hueProperty, 360),
    SATURATION("Saturation", Color.web((String)"ffffff"), ExtendedColor::saturationProperty, 100),
    BRIGHTNESS("Luminosit\u00e9", Color.web((String)"ffffff"), ExtendedColor::brightnessProperty, 100),
    CYAN("Cyan", Color.web((String)"14d2d9"), ExtendedColor::cyanProperty, 100),
    MAGENTA("Magenta", Color.web((String)"d94acd"), ExtendedColor::magentaProperty, 100),
    YELLOW("Jaune", Color.web((String)"d9c345"), ExtendedColor::yellowProperty, 100),
    BLACK("Noir", Color.web((String)"424242"), ExtendedColor::blackProperty, 100);

    private final Color HEADER_COLOR;
    private final String HEADER_NAME;
    private final Function<ExtendedColor, SimpleDoubleProperty> GETTER;
    private final int MAXIMUM_VALUE;

    private ColorComponent(String headerName, Color headerColor, Function<ExtendedColor, SimpleDoubleProperty> componentGetter, int max) {
        this.HEADER_NAME = headerName;
        this.HEADER_COLOR = headerColor;
        this.GETTER = componentGetter;
        this.MAXIMUM_VALUE = max;
    }

    private ColorComponent(String headerName, Color headerColor, Function<ExtendedColor, SimpleDoubleProperty> componentGetter) {
        this(headerName, headerColor, componentGetter, 255);
    }

    public double getValue01(ExtendedColor color) {
        return this.GETTER.apply(color).get();
    }

    public double getValue01(Color color) {
        return this.getValue01(new ExtendedColor(color));
    }

    public int getValueInt(ExtendedColor color) {
        int MAXIMUM = this.equals((Object)HUE) ? 1 : this.MAXIMUM_VALUE;
        return (int)Math.round(this.getValue01(color) * (double)MAXIMUM);
    }

    public int getValueInt(Color color) {
        return this.getValueInt(new ExtendedColor(color));
    }

    public int getMaximum() {
        return this.MAXIMUM_VALUE;
    }

    public String cssClass() {
        return this.name().toLowerCase();
    }

    public Color getHeaderColor() {
        return this.HEADER_COLOR;
    }

    public SimpleDoubleProperty value01Property(ExtendedColor color) {
        return this.GETTER.apply(color);
    }

    public SimpleDoubleProperty valueProperty(ExtendedColor color) {
        return (SimpleDoubleProperty)Bindings.multiply((int)this.MAXIMUM_VALUE, (ObservableNumberValue)((ObservableNumberValue)this.GETTER.apply(color)));
    }

    public String toString() {
        return this.HEADER_NAME;
    }
}

