/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.enums;

import colorfix.app.enums.ColorComponent;
import java.util.Arrays;
import java.util.Iterator;

public enum ColorSpace implements Iterable<ColorComponent>
{
    RGB("RGB", ColorComponent.RED, ColorComponent.GREEN, ColorComponent.BLUE),
    HSB("HSB", ColorComponent.HUE, ColorComponent.SATURATION, ColorComponent.BRIGHTNESS),
    CMYK("CMYK", ColorComponent.CYAN, ColorComponent.MAGENTA, ColorComponent.YELLOW, ColorComponent.BLACK);

    private final String NAME;
    private final ColorComponent[] COMPONENTS;

    private ColorSpace(String name, ColorComponent ... components) {
        this.NAME = name;
        this.COMPONENTS = Arrays.copyOf(components, components.length);
    }

    public boolean contains(ColorComponent component) {
        return Arrays.asList(this.COMPONENTS).contains((Object)component);
    }

    @Override
    public Iterator<ColorComponent> iterator() {
        return Arrays.stream(this.COMPONENTS).iterator();
    }

    public String toString() {
        return this.NAME;
    }
}

