/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.stages;

import colorfix.app.ColorFX;
import colorfix.app.controls.StyledScene;
import colorfix.app.stages.ExtendedStage;
import colorfix.app.util.Assets;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.StageStyle;

public class AboutStage
extends ExtendedStage {
    private Label applicationTitle;
    private Label applicationDescription;
    private HBox descriptionContainer;
    private Separator separatorA;
    private Separator separatorB;
    private TextArea textZone;
    private Hyperlink gitlabUrl;
    private Button closeBtn;

    public AboutStage() {
        VBox root = new VBox();
        root.setAlignment(Pos.CENTER);
        root.setPadding(new Insets(18.0));
        root.setSpacing(6.0);
        this.applicationTitle = new Label("ColorFX");
        this.applicationTitle.setFont(new Font("Arial", 32.0));
        this.descriptionContainer = new HBox();
        this.descriptionContainer.setAlignment(Pos.CENTER);
        this.descriptionContainer.setPadding(Insets.EMPTY);
        this.descriptionContainer.setSpacing(4.0);
        HBox.setHgrow((Node)this.descriptionContainer, (Priority)Priority.ALWAYS);
        this.applicationDescription = new Label("Correcteur de teinte pour impression noir et blanc.");
        this.gitlabUrl = new Hyperlink("Lien GitLab");
        this.gitlabUrl.setOnAction(this::onGitLabLinkClicked);
        this.descriptionContainer.getChildren().addAll((Object[])new Node[]{this.applicationDescription, this.gitlabUrl});
        this.separatorA = new Separator(Orientation.HORIZONTAL);
        HBox.setHgrow((Node)this.separatorA, (Priority)Priority.ALWAYS);
        this.textZone = new TextArea(Assets.readtextFile("about.txt"));
        this.textZone.setWrapText(true);
        this.textZone.setEditable(false);
        this.textZone.setPrefWidth(300.0);
        this.separatorB = new Separator(Orientation.HORIZONTAL);
        HBox.setHgrow((Node)this.separatorB, (Priority)Priority.ALWAYS);
        this.closeBtn = new Button("Fermer");
        this.closeBtn.setDefaultButton(true);
        this.closeBtn.setOnAction(this::onCloseClicked);
        root.getChildren().addAll((Object[])new Node[]{this.applicationTitle, this.descriptionContainer, this.separatorA, this.textZone, this.separatorB, this.closeBtn});
        StyledScene scene = new StyledScene((Parent)root);
        this.setScene(scene);
        this.setResizable(false);
        this.initStyle(StageStyle.UTILITY);
        this.setTitle("\u00c0 propos");
        this.closeBtn.requestFocus();
    }

    private void onCloseClicked(ActionEvent e) {
        this.close();
    }

    private void onGitLabLinkClicked(ActionEvent e) {
        ColorFX.hostServices().showDocument("https://gitlab.univ-lille.fr/neo.almeida.etu/ColorFX");
    }
}

