/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.stages;

import colorfix.app.Constants;
import colorfix.app.controls.CopyTableView;
import colorfix.app.controls.StyledScene;
import colorfix.app.stages.ExtendedStage;
import colorfix.app.util.ColorAdjust;
import colorfix.app.util.ColorUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ToolBar;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class CalibrateStage
extends ExtendedStage {
    private Button exportBtn;
    private CopyTableView colorTable;
    private final CheckBox showCmykColumn;
    private FileChooser fileChooser;
    private File file;
    private final Clipboard clipboard = Clipboard.getSystemClipboard();
    private final ClipboardContent content = new ClipboardContent();

    public CalibrateStage(Collection<Color> collection, boolean isCmykVisible) {
        BorderPane root = new BorderPane();
        ToolBar menu = new ToolBar();
        this.exportBtn = new Button("Exporter");
        this.exportBtn.setOnAction(this::onExportClicked);
        this.fileChooser = new FileChooser();
        this.fileChooser.getExtensionFilters().addAll((Object[])Constants.FILTERS);
        this.showCmykColumn = new CheckBox("Couleurs d'imprimante (CMJN)");
        menu.getItems().addAll((Object[])new Node[]{this.exportBtn, this.showCmykColumn});
        menu.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/style.css").toExternalForm());
        root.setTop((Node)menu);
        this.colorTable = new CopyTableView();
        root.setCenter((Node)this.colorTable);
        List<Color> newCollec = ColorAdjust.autoAdjust(collection);
        this.colorTable.getItems().addAll(newCollec);
        if (isCmykVisible) {
            this.showCmykColumn.setSelected(isCmykVisible);
        }
        this.colorTable.cmykVisibleProperty().bind((ObservableValue)this.showCmykColumn.selectedProperty());
        this.colorTable.rgbVisibleProperty().bind((ObservableValue)this.showCmykColumn.selectedProperty().not());
        StyledScene scene = new StyledScene((Parent)root);
        this.setScene(scene);
        this.setResizable(false);
        this.setTitle("ColorFX");
        Runnable kcExport = () -> this.onExportClicked(new ActionEvent());
        this.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), (Object)kcExport);
        Runnable kcCopy = () -> this.copy(new ActionEvent());
        this.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), (Object)kcCopy);
    }

    private void onExportClicked(ActionEvent e) {
        this.file = this.fileChooser.showSaveDialog((Window)this);
        if (this.file != null) {
            String res = "";
            for (Color c : this.colorTable.getItems()) {
                res = String.valueOf(res) + ColorUtil.tohexCode(c) + "\n";
            }
            try {
                PrintWriter pw = new PrintWriter(this.file);
                pw.print(res);
                pw.close();
            }
            catch (IOException ioex) {
                System.out.println(ioex);
            }
        }
    }

    private void copy(ActionEvent e) {
        System.out.println("Copy");
        if (!this.colorTable.getSelectionModel().isEmpty()) {
            System.out.println(ColorUtil.tohexCode((Color)this.colorTable.getSelectionModel().getSelectedItem()));
            this.content.putString(ColorUtil.tohexCode((Color)this.colorTable.getSelectionModel().getSelectedItem()));
            this.clipboard.setContent((Map)this.content);
        }
    }
}

