/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.stages;

import colorfix.app.ExtendedColor;
import colorfix.app.controls.StyledScene;
import colorfix.app.controls.picker.ColorSquare;
import colorfix.app.controls.slider.ColorSliderTabs;
import colorfix.app.stages.ExtendedStage;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

public class ColorPickerStage
extends ExtendedStage {
    private ColorSquare picker;
    private ColorSliderTabs sliders;
    private ExtendedColor color;
    private HBox root = new HBox();

    public ColorPickerStage() {
        this(Color.RED);
    }

    public ColorPickerStage(Color c) {
        this.root.setSpacing(0.0);
        this.picker = new ColorSquare();
        this.sliders = new ColorSliderTabs();
        Tab pickerTab = new Tab("Couleur", (Node)this.picker);
        pickerTab.setClosable(false);
        TabPane pickerPane = new TabPane(new Tab[]{pickerTab});
        this.root.getChildren().addAll((Object[])new Node[]{pickerPane, this.sliders});
        this.color = new ExtendedColor(c);
        this.picker.colorProperty().bindBidirectional(this.color.colorProperty());
        this.sliders.colorProperty().bindBidirectional(this.color.colorProperty());
        this.picker.prefHeightProperty().bind((ObservableValue)this.root.heightProperty());
        this.picker.prefWidthProperty().bind((ObservableValue)this.picker.prefHeightProperty());
        HBox.setHgrow((Node)this.sliders, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.sliders, (Priority)Priority.ALWAYS);
        StyledScene scene = new StyledScene((Parent)this.root, 680.0, 320.0);
        this.setScene(scene);
    }
}

