/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.stages;

import colorfix.app.Constants;
import colorfix.app.controls.StyledScene;
import colorfix.app.stages.ExtendedStage;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;

public class ErrorStage
extends ExtendedStage {
    private Button closeBtn;
    private Label labelError;

    public ErrorStage(String errorString) {
        VBox root = new VBox();
        root.setPadding(new Insets(18.0));
        root.setSpacing(10.0);
        Separator separator = new Separator(Orientation.HORIZONTAL);
        ImageView image = new ImageView(Constants.APP_ICON_ERROR);
        image.setPreserveRatio(true);
        image.setFitHeight(50.0);
        image.setSmooth(true);
        image.setCache(true);
        this.closeBtn = new Button("Fermer");
        this.closeBtn.setDefaultButton(true);
        this.closeBtn.setId("toolbarButton");
        this.closeBtn.setOnAction(this::onCloseBtnClicked);
        this.labelError = new Label(errorString);
        root.getChildren().addAll((Object[])new Node[]{this.labelError, image, separator, this.closeBtn});
        root.setAlignment(Pos.CENTER);
        StyledScene scene = new StyledScene((Parent)root, 300.0, 150.0);
        this.setScene(scene);
        this.setResizable(false);
        this.setTitle("Error");
        this.closeBtn.requestFocus();
        this.getIcons().add((Object)Constants.APP_ICON_ERROR);
    }

    private void onCloseBtnClicked(ActionEvent e) {
        this.close();
    }
}

