/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.stages;

import colorfix.app.Constants;
import colorfix.app.controls.StyledScene;
import colorfix.app.controls.table.ActionLink;
import colorfix.app.controls.table.ColorTableView;
import colorfix.app.controls.table.TablePlaceholder;
import colorfix.app.stages.AboutStage;
import colorfix.app.stages.CalibrateStage;
import colorfix.app.stages.ErrorStage;
import colorfix.app.stages.ExtendedStage;
import colorfix.app.stages.QuestionStage;
import colorfix.app.stages.dialogs.ColorChooserDialog;
import colorfix.app.util.ColorUtil;
import colorfix.app.util.MessageBox;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Scanner;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ToolBar;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class MainStage
extends ExtendedStage {
    private final Button addBtn;
    private final Button importBtn;
    private final Button exportBtn;
    private final Button removeAllBtn;
    private final Button questionMark;
    private final Button aboutBtn;
    private final Button calibrateBtn;
    private final Region menuSpacer;
    private final Region menuSpacer2;
    private final ColorTableView colorTable;
    private final CheckBox showCmykColumn;
    private final TablePlaceholder tablePlaceholder;
    private final ActionLink addColorLink;
    private final ActionLink openFileLink;
    private AboutStage aboutWindow;
    private CalibrateStage calibrateWindow;
    private ErrorStage errorWindow;
    private QuestionStage questionWindow;
    private final FileChooser fileChooser;
    private File file;
    private final Clipboard clipboard = Clipboard.getSystemClipboard();
    private final ClipboardContent content = new ClipboardContent();
    private SimpleBooleanProperty changed = new SimpleBooleanProperty(true);

    public MainStage() {
        BorderPane root = new BorderPane();
        ToolBar menu = new ToolBar();
        this.addBtn = new Button("Ajouter", (Node)Constants.loadImage(Constants.ADD_ICON));
        this.removeAllBtn = new Button("Tout supprimer", (Node)Constants.loadImage(Constants.DEL_ICON));
        this.aboutBtn = new Button("\u00c0 propos");
        this.addBtn.setAlignment(Pos.BASELINE_RIGHT);
        this.importBtn = new Button("Importer", (Node)Constants.loadImage(Constants.LOAD_ICON));
        this.importBtn.setOnAction(this::onImportClicked);
        this.aboutBtn.setStyle("-fx-base: lightgray;");
        this.addBtn.setId("toolbarButton");
        this.removeAllBtn.setId("toolbarButton");
        this.aboutBtn.setId("toolbarButton");
        this.exportBtn = new Button("Exporter", (Node)Constants.loadImage(Constants.EXP_ICON));
        this.exportBtn.setOnAction(this::onExportClicked);
        this.questionMark = new Button("", (Node)Constants.loadImage(Constants.QUES_ICON));
        this.questionMark.setOnAction(this::onQuestion);
        this.menuSpacer = new Region();
        HBox.setHgrow((Node)this.menuSpacer, (Priority)Priority.ALWAYS);
        this.showCmykColumn = new CheckBox("Couleurs d'imprimante (CMJN)");
        menu.getItems().addAll((Object[])new Node[]{this.addBtn, this.removeAllBtn, this.showCmykColumn, this.menuSpacer, this.questionMark, this.aboutBtn});
        menu.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/style.css").toExternalForm());
        root.setTop((Node)menu);
        this.calibrateBtn = new Button("Calibrer les couleurs", (Node)Constants.loadImage(Constants.REC_ICON));
        this.calibrateBtn.setDefaultButton(true);
        this.menuSpacer2 = new Region();
        HBox.setHgrow((Node)this.menuSpacer2, (Priority)Priority.ALWAYS);
        HBox bottomButtons = new HBox(new Node[]{this.importBtn, this.exportBtn, this.menuSpacer2, this.calibrateBtn});
        bottomButtons.setPadding(new Insets(8.0));
        bottomButtons.setSpacing(8.0);
        bottomButtons.setId("dark");
        root.setBottom((Node)bottomButtons);
        this.colorTable = new ColorTableView();
        this.colorTable.cmykVisibleProperty().bind((ObservableValue)this.showCmykColumn.selectedProperty());
        this.colorTable.rgbVisibleProperty().bind((ObservableValue)this.showCmykColumn.selectedProperty().not());
        this.colorTable.getRGBColumn().prefWidthProperty().bindBidirectional((Property)this.colorTable.getCMYKColumn().prefWidthProperty());
        this.changed.setValue(Boolean.valueOf(true));
        this.exportBtn.disableProperty().bind((ObservableValue)this.colorTable.isEmptyProperty());
        this.calibrateBtn.disableProperty().bind((ObservableValue)this.colorTable.isEmptyProperty());
        this.removeAllBtn.disableProperty().bind((ObservableValue)this.colorTable.isEmptyProperty());
        this.addColorLink = new ActionLink("Ajouter une couleur", (EventHandler<ActionEvent>)((EventHandler)this::onAddClicked));
        this.openFileLink = new ActionLink("Charger des couleurs depuis un fichier");
        this.openFileLink.setOnAction(this::onImportClicked);
        this.tablePlaceholder = new TablePlaceholder("ColorFX", Constants.APP_ICON, "C'est un peu vide par ici...", new Node[]{this.addColorLink, this.openFileLink});
        this.colorTable.setPlaceholder((Node)this.tablePlaceholder);
        root.setCenter((Node)this.colorTable);
        this.setTooltip((Node)this.addBtn, "Ouvrir une boite de dialogue pour s\u00e9lectionner une couleur \u00e0 ajouter");
        this.setTooltip((Node)this.removeAllBtn, "Vider la liste des couleurs");
        this.setTooltip((Node)this.aboutBtn, "Afficher des informations sur ce logiciel");
        this.setTooltip((Node)this.calibrateBtn, "Recalibrer les couleurs et les afficher dans une nouvelle fen\u00eatre");
        this.addBtn.setOnAction(this::onAddClicked);
        this.removeAllBtn.setOnAction(this::onRemoveAllClicked);
        this.aboutBtn.setOnAction(this::onAboutClicked);
        this.calibrateBtn.setOnAction(this::onCalibrateClicked);
        this.aboutBtn.prefHeightProperty().bind((ObservableValue)this.questionMark.heightProperty());
        StyledScene scene = new StyledScene((Parent)root);
        this.setScene(scene);
        this.setTitle("ColorFX");
        this.fileChooser = new FileChooser();
        this.fileChooser.getExtensionFilters().addAll((Object[])Constants.FILTERS);
        Runnable kcImport = () -> this.onImportClicked(new ActionEvent());
        this.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), (Object)kcImport);
        Runnable kcExport = () -> this.onExportClicked(new ActionEvent());
        this.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), (Object)kcExport);
        Runnable kcNew = () -> this.onRemoveAllClicked(new ActionEvent());
        this.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), (Object)kcNew);
        Runnable kcCalibrate = () -> this.onCalibrateClicked(new ActionEvent());
        this.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), (Object)kcCalibrate);
        Runnable kcCopy = () -> this.copy(new ActionEvent());
        this.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), (Object)kcCopy);
        this.colorTable.getItems().addListener((ListChangeListener)new ListChangeListener<Color>(){

            public void onChanged(ListChangeListener.Change<? extends Color> c) {
                MainStage.this.changed.setValue(Boolean.valueOf(true));
                System.out.println(MainStage.this.changed.get());
            }
        });
    }

    private void onQuestion(ActionEvent actionEvent) {
        if (this.questionWindow == null || !this.questionWindow.isShowing()) {
            this.questionWindow = new QuestionStage();
            this.questionWindow.initOwner((Window)this);
            this.questionWindow.show();
        } else {
            this.questionWindow.close();
            this.questionWindow = null;
        }
    }

    private void onExportClicked(ActionEvent e) {
        if (this.changed.getValue().booleanValue()) {
            this.file = this.fileChooser.showSaveDialog((Window)this);
        }
        if (this.file != null) {
            String res = "";
            for (Color c : this.colorTable.getItems()) {
                res = String.valueOf(res) + ColorUtil.tohexCode(c) + "\n";
            }
            try {
                try {
                    PrintWriter pw = new PrintWriter(this.file);
                    pw.print(res);
                    pw.close();
                }
                catch (IOException ioex) {
                    System.out.println(ioex);
                    this.changed.set(false);
                }
            }
            finally {
                this.changed.set(false);
            }
        }
    }

    private void onAddClicked(ActionEvent e) {
        Color c = ColorChooserDialog.open();
        if (c != null) {
            this.colorTable.getItems().add((Object)c);
        }
    }

    private void onRemoveAllClicked(ActionEvent e) {
        if (MessageBox.showConfirm("Tout supprimer", "Vous \u00eates sur le point de vider la liste des couleurs s\u00e9lectionn\u00e9es.\nVoulez-vous continuer ?") == ButtonType.OK) {
            this.colorTable.getItems().removeAll((Collection)this.colorTable.getItems());
        }
    }

    private void onAboutClicked(ActionEvent e) {
        if (this.aboutWindow == null || !this.aboutWindow.isShowing()) {
            this.aboutWindow = new AboutStage();
            this.aboutWindow.initOwner((Window)this);
            this.aboutWindow.show();
        } else {
            this.aboutWindow.close();
            this.aboutWindow = null;
        }
    }

    private void onCalibrateClicked(ActionEvent e) {
        System.out.println(this.colorTable.getItems().size());
        if (this.calibrateWindow == null || !this.calibrateWindow.isShowing()) {
            this.calibrateWindow = new CalibrateStage((Collection<Color>)this.colorTable.getItems(), this.colorTable.cmykVisibleProperty().get());
            this.calibrateWindow.initOwner((Window)this);
            this.calibrateWindow.show();
        } else {
            this.calibrateWindow.close();
            this.calibrateWindow = null;
        }
    }

    private void onImportClicked(ActionEvent e) {
        Boolean importSucces = false;
        this.file = this.fileChooser.showOpenDialog((Window)this);
        int foundColors = 0;
        ArrayList<Color> list = new ArrayList<Color>();
        if (this.file != null && this.file.exists()) {
            try {
                Scanner sc = new Scanner(this.file);
                while (sc.hasNext()) {
                    String nextLine = sc.nextLine();
                    if (ColorUtil.isAnHexcode(nextLine)) {
                        list.add(Color.web((String)nextLine));
                        ++foundColors;
                        continue;
                    }
                    throw new InvalidParameterException();
                }
                importSucces = true;
            }
            catch (Throwable exc) {
                MessageBox.showDoge("Erreur d'importation", "Le contenu du fichier n'est pas valide !");
                importSucces = false;
                foundColors = -1;
            }
        }
        if (foundColors == 0) {
            MessageBox.showDoge("Erreur d'importation", "Le fichier ne contient pas de couleur importable !");
        } else if (importSucces.booleanValue()) {
            this.colorTable.getItems().removeAll((Collection)this.colorTable.getItems());
            this.colorTable.getItems().addAll(list);
            importSucces = false;
        }
    }

    private void copy(ActionEvent e) {
        if (!this.colorTable.getSelectionModel().isEmpty()) {
            this.content.putString(ColorUtil.tohexCode((Color)this.colorTable.getSelectionModel().getSelectedItem()));
            this.clipboard.setContent((Map)this.content);
        }
    }
}

