/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.stages.dialogs;

import colorfix.app.ExtendedColor;
import colorfix.app.controls.ColorThumbnail;
import colorfix.app.controls.StyledScene;
import colorfix.app.controls.picker.ColorSquare;
import colorfix.app.controls.slider.ColorSliderTabs;
import colorfix.app.stages.ExtendedStage;
import colorfix.app.util.Assets;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.StageStyle;

public class ColorChooserDialog
extends ExtendedStage {
    private final ExtendedColor color;
    private Color result = null;

    public ColorChooserDialog() {
        this(Color.LIME);
    }

    public ColorChooserDialog(ExtendedColor color) {
        this(color.getColor());
    }

    public ColorChooserDialog(Color color) {
        this.color = new ExtendedColor(color);
        HBox root = new HBox();
        root.setAlignment(Pos.CENTER);
        ColorSquare square = new ColorSquare(color);
        square.setPrefSize(300.0, 300.0);
        ColorThumbnail thumb = new ColorThumbnail(color);
        thumb.setPrefSize(300.0, 32.0);
        ColorSliderTabs sliders = new ColorSliderTabs(color);
        sliders.setPrefSize(300.0, 250.0);
        TabPane colorTabPane = new TabPane();
        HBox thumbPane = new HBox(new Node[]{thumb});
        thumbPane.setPadding(new Insets(0.0, 12.0, 12.0, 12.0));
        VBox colorRoot = new VBox(new Node[]{square, thumbPane});
        Tab colorTab = new Tab("Couleur", (Node)colorRoot);
        colorTab.setClosable(false);
        colorTabPane.getTabs().add((Object)colorTab);
        VBox sliderRoot = new VBox();
        Button confirmButton = new Button("S\u00e9lectionner");
        confirmButton.setDefaultButton(true);
        confirmButton.setOnAction(this::onConfirmClicked);
        confirmButton.getStyleClass().addAll((Object[])new String[]{"pill-button", "left-pill"});
        Button cancelButton = new Button("Annuler");
        cancelButton.setOnAction(this::onCancelClicked);
        cancelButton.getStyleClass().addAll((Object[])new String[]{"pill-button", "right-pill"});
        HBox buttonsRoot = new HBox(new Node[]{confirmButton, cancelButton});
        buttonsRoot.getStylesheets().add((Object)Assets.getAssetPath("/pill-button.css"));
        buttonsRoot.setAlignment(Pos.CENTER_RIGHT);
        buttonsRoot.setPadding(thumbPane.getPadding());
        sliderRoot.getChildren().addAll((Object[])new Node[]{sliders, buttonsRoot});
        root.getChildren().addAll((Object[])new Node[]{colorTabPane, sliderRoot});
        this.setGrow((Node)square, Priority.ALWAYS, Priority.ALWAYS);
        this.setGrow((Node)thumb, Priority.ALWAYS, Priority.ALWAYS);
        this.setGrow((Node)sliders, Priority.ALWAYS, Priority.ALWAYS);
        this.setGrow((Node)thumbPane, Priority.ALWAYS, Priority.SOMETIMES);
        this.setGrow((Node)colorTabPane, Priority.SOMETIMES, Priority.ALWAYS);
        thumb.colorProperty().bind(square.colorProperty());
        sliders.colorProperty().bindBidirectional(square.colorProperty());
        this.color.colorProperty().bind(square.colorProperty());
        StyledScene scene = new StyledScene((Parent)root);
        this.setScene(scene);
        this.setTitle("S\u00e9lecteur de couleur");
        this.setResizable(false);
        this.initStyle(StageStyle.UTILITY);
        confirmButton.requestFocus();
    }

    private void onConfirmClicked(ActionEvent e) {
        this.result = this.getColor();
        this.close();
    }

    private void onCancelClicked(ActionEvent e) {
        this.close();
    }

    private void setGrow(Node node, Priority hgrow, Priority vgrow) {
        HBox.setHgrow((Node)node, (Priority)hgrow);
        VBox.setVgrow((Node)node, (Priority)vgrow);
    }

    public Color getColor() {
        return this.color.getColor();
    }

    public static Color open() {
        return ColorChooserDialog.open(Color.RED);
    }

    public static Color open(Color color) {
        return ColorChooserDialog.open(new ExtendedColor(color));
    }

    public static Color open(ExtendedColor initialColor) {
        ColorChooserDialog dialog = new ColorChooserDialog(initialColor);
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.showAndWait();
        return dialog.result;
    }
}

