/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.types;

import colorfix.app.util.Maths;
import javafx.beans.property.SimpleDoubleProperty;

public class SimpleNormalizedProperty
extends SimpleDoubleProperty {
    private final double MAXIMUM;

    public SimpleNormalizedProperty() {
        this(0.0, 1.0);
    }

    public SimpleNormalizedProperty(double initialValue) {
        this(initialValue, 1.0);
    }

    public SimpleNormalizedProperty(double initialValue, double maximum) {
        this.MAXIMUM = maximum;
        this.set(initialValue);
    }

    public double get() {
        return Maths.clamp(super.get(), 0.0, this.MAXIMUM);
    }

    public void set(double newValue) {
        super.set(Maths.clamp(newValue, 0.0, this.MAXIMUM));
    }

    public void setNormalized(double value) {
        this.setValue(value * this.MAXIMUM);
    }

    public Double getValue() {
        return this.get();
    }

    public double getNormalized() {
        return this.getValue() / this.MAXIMUM;
    }

    public void setValue(Number v) {
        this.set(v.doubleValue());
    }

    public double getMaximum() {
        return this.MAXIMUM;
    }
}

