/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.util;

import colorfix.app.ColorGrayscaleComparator;
import colorfix.app.util.Maths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.scene.paint.Color;

public class ColorAdjust {
    public static List<Color> autoAdjust(Collection<Color> colors) {
        ColorGrayscaleComparator comparator = new ColorGrayscaleComparator();
        ArrayList<Color> sourceColors = new ArrayList<Color>(colors);
        sourceColors.sort(comparator);
        ArrayList<Color> newColors = new ArrayList<Color>();
        double delta = 1.0 / (double)(colors.size() - 1);
        Optional<Color> minColor = sourceColors.stream().min(comparator);
        Optional<Color> maxColor = sourceColors.stream().max(comparator);
        double minBrightness = minColor.isPresent() ? minColor.get().getBrightness() : 0.0;
        double maxBrightness = maxColor.isPresent() ? maxColor.get().getBrightness() : 1.0;
        int i = 0;
        while (i < colors.size()) {
            Color oldCol = (Color)sourceColors.get(i);
            double hue = oldCol.getHue();
            double sat = Math.pow(oldCol.getSaturation(), 0.8);
            double bri = Maths.map(Math.pow((double)i * delta, 0.8), 0.0, 1.0, minBrightness, maxBrightness);
            Color newCol = Color.hsb((double)hue, (double)sat, (double)bri);
            newColors.add(newCol);
            ++i;
        }
        newColors.sort(new ColorGrayscaleComparator());
        return newColors;
    }
}

