/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.paint.Color;

public class ColorUtil {
    public static String tohexCode(Color color) {
        return String.format("#%02X%02X%02X", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    public static Color grayScaleColor(Color color) {
        int gray = (int)Math.round(255.0 * ColorUtil.grayScaleValue(color));
        return Color.grayRgb((int)gray);
    }

    public static double grayScaleValue(Color color) {
        double r = 0.3 * color.getRed();
        double g = 0.59 * color.getGreen();
        double b = 0.11 * color.getBlue();
        return r + g + b;
    }

    public static ArrayList<Color> toGrayNeo2(Collection<Color> collection) {
        ArrayList<Color> grayList = new ArrayList<Color>();
        double size = collection.size() + 1;
        int i = 0;
        while (i < collection.size()) {
            grayList.add(Color.hsb((double)0.0, (double)0.0, (double)((double)(i + 1) / size)));
            ++i;
        }
        return grayList;
    }

    public static boolean isAnHexcode(String hex) {
        String res = hex.replaceAll("\\\\n", "");
        Pattern perfectHex = Pattern.compile("^#([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$");
        Matcher matcher = perfectHex.matcher(res);
        return matcher.find();
    }
}

