/*
 * Decompiled with CFR 0.152.
 */
package colorfix.app.util;

import colorfix.app.Constants;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.image.ImageView;

public final class MessageBox {
    public static ButtonType showConfirm(String title, String content) {
        return (ButtonType)MessageBox.createAlert(title, content, Alert.AlertType.CONFIRMATION).showAndWait().get();
    }

    public static ButtonType showInfo(String title, String content) {
        return (ButtonType)MessageBox.createAlert(title, content, Alert.AlertType.INFORMATION).showAndWait().get();
    }

    public static ButtonType showWarning(String title, String content) {
        return (ButtonType)MessageBox.createAlert(title, content, Alert.AlertType.WARNING).showAndWait().get();
    }

    public static ButtonType showError(String title, String content) {
        return (ButtonType)MessageBox.createAlert(title, content, Alert.AlertType.ERROR).showAndWait().get();
    }

    public static ButtonType showDoge(String title, String content) {
        Alert alert = MessageBox.createAlert(title, content, Alert.AlertType.ERROR);
        ImageView img = Constants.loadImage(Constants.APP_ICON_ERROR);
        img.setFitWidth(64.0);
        img.setFitHeight(64.0);
        alert.setGraphic((Node)img);
        return (ButtonType)alert.showAndWait().get();
    }

    private static Alert createAlert(String title, String content, Alert.AlertType type) {
        Alert alert = new Alert(type);
        alert.setTitle("");
        alert.setHeaderText(title);
        alert.setContentText(content);
        return alert;
    }
}

